
/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  2C_Mini-serre Seq2 Regulation taux humidite a modifier.INO
   Document : Dossier Mini Serre Arduino
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur                Variable Arduino  Broche AutoProg Uno

Fin de course fenêtre repliée   fdc_fermeture             A0
Fin de course fenêtre dépliée   fdc_ouverture             A1
Capteur de température          Voir bibliothèque         A2
Capteur d’hygrométrie           hygrometrie               A3
Capteur d’humidité                humidite                  A4
Bouton poussoir                 bouton_poussoir           3


Module actionneur         Variable Arduino  Broche AutoProg Uno

Pompe                         pompe                     4
Ventilateur                   ventilateur               5
Brumisateur                   brumisateur               6
Plateau chauffant             plateau_chaffant          7
Afficheur OLED                OLED                      8
Moteur ouverture              ouverture                 9
Moteur fermeture              fermeture                 10
    


------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque

//Définition des variables, constantes et pin :


byte niveau_humidite; // Variable qui stockera le niveau d'humidité de la terre

// Pin d'entrées

const int humidite            = A3;

//Pin de sorties

const int pompe               = 4;

//Initialisation

void setup()
{
  Serial.begin(9600); // Activation de la liaison série pour observer les résultat des capteurs avec le moniteur série (bouton en haut  à droite de l'IDE Arduino)
    
    // Définition des pins comme des entrées

    pinMode (humidite, INPUT);
     
    // Définition des pins comme des sorties
    pinMode (pompe, OUTPUT);  

    
}



//Programme principal

//Boucle infinie

void loop(void)
{ 
  niveau_humidite = analogRead(humidite); // variable niveau_hygrometrie contenant le niveau d'humidité dans la terre
  niveau_humidite = (niveau_humidite *0,4)-3; // Calcul pour passer le niveau d'hygrométrie en %
  
  if (niveau_humidite<68) // Si le niveau d'humidité de la terre est inférieur à 68% 
  {
    digitalWrite(pompe,HIGH);  // Activer la pompe
    delay (1000); // Activation de la pompe pendant 1 seconde
    digitalWrite(pompe,LOW);  // Arrêt de la pompe
    delay (5000); // Attendre 5 secondes le temps que l'eau se propage
  }
}

// Fonctions
  




