#include <Arduino.h>
#include "A4RoboMobile.h"

RoboMobile::RoboMobile(){	
	pinMode(9,OUTPUT);
	pinMode(10,OUTPUT);
	pinMode(11,OUTPUT);
	pinMode(12,OUTPUT);
	mySerial.begin(9600);
}
	
int RoboMobile::bluetoothDernierOctet(){
	int var_blt;
	while(mySerial.available())	{
		var_blt = mySerial.read();
	}
	return(var_blt);  // retourne null si pas de donnée 
}

void RoboMobile::moteur(int sensRot){
	if(sensRot == 1 ){	//Avancer
		digitalWrite(9,1);
		digitalWrite(10,0);
		digitalWrite(11,1);
		digitalWrite(12,0);
	}

	else if(sensRot == 2 ){	//Reculer 
		digitalWrite(9,0);
		digitalWrite(10,1);
		digitalWrite(11,0);
		digitalWrite(12,1);
	}
	else if(sensRot == 3 ){	//arret du moteur 
		digitalWrite(9,0);
		digitalWrite(10,0);
		digitalWrite(11,0);
		digitalWrite(12,0);
	}
	else if(sensRot == 4 ){	//Tourner à gauche
		digitalWrite(9,1);
		digitalWrite(10,0);
		digitalWrite(11,0);
		digitalWrite(12,1);
	}
	else if(sensRot == 5 ){	//Tourner à droite
		digitalWrite(9,0);
		digitalWrite(10,1);
		digitalWrite(11,1);
		digitalWrite(12,0);
	}
}

void RoboMobile::ecrireBLTH (int message){
	mySerial.write(message);
}