#include <Arduino.h>
#include "A4_OLED.h"

#define bitWidth 417

A4Oled::A4Oled(int pin)
{
  _pin = pin;
  pinMode(_pin,OUTPUT);
}

void A4Oled::OLEDwriteByte(byte data)
{
  digitalWrite(_pin, HIGH); //start bit
  delayMicroseconds(bitWidth);
  for (byte mask = 0x01; mask; mask <<= 1)
  {
    if (data & mask) digitalWrite(_pin,LOW);
    else digitalWrite(_pin,HIGH);
    delayMicroseconds(bitWidth);
  }
  digitalWrite(_pin, LOW); //end bit
  delayMicroseconds(bitWidth);
  delayMicroseconds(300); //inter-byte delay
}

void A4Oled::OLEDwriteString(String buffer, int line, int column)
{
  OLEDcursorAbs(line,column);
  for(int i = 0; i< buffer.length(); i++) OLEDwriteByte(buffer[i]);
}

void A4Oled::OLEDcursorAbs(int line, int column)
{
  OLEDwriteByte(254);
  if(line == 1) column += 128;
  else column +=192;
  OLEDwriteByte(column);
}

void A4Oled::OLEDclearScreen()
{
  OLEDwriteByte(254);
  OLEDwriteByte(1);
  delay(30); //wait for display to finish updating
}

void A4Oled::OLEDSetDisplayState(int state)
{
  OLEDwriteByte(254);
  if(state == 1) OLEDwriteByte(12);
  else OLEDwriteByte(8);
}