#include <Arduino.h>
#include "A4FeuxTricolores.h"

/*
  Plan de cablage pour Lotus Groove:
    > Feux Tricolores n°1: Rouge = D4 / Orange = D3 / Vert D2
    > Feux Tricolores n°2: Rouge = D7 / Orange = D6 / Vert D5
    > Feux pietons: Rouge = A2 / Vert = A0
    > Bouton poussoir: I2C (SCL = pin n°19)
*/

FeuxTricolores::FeuxTricolores(){
  for (int i=7;i>=2;i--){
    pinMode(i,OUTPUT);
  }
}

FeuPietons::FeuPietons(){
  pinMode(18,OUTPUT);
  pinMode(16,OUTPUT);
}

void FeuxTricolores::changer_feu_tricolore (int feu, int couleur){
  bool feux_etat[3] = {0,0,0};
  switch(couleur){
    case 1: feux_etat[0] = 1; break;
    case 2: feux_etat[1] = 1; break;
    case 3: feux_etat[2] = 1; break;
    default:break;
  }
  digitalWrite(this->feu_rouge[feu-1],feux_etat[0]);
  digitalWrite(this->feu_orange[feu-1],feux_etat[1]);
  digitalWrite(this->feu_vert[feu-1],feux_etat[2]);
}

void FeuPietons::changer_feu_pietons (int couleur){
  switch(couleur){
    case 1: digitalWrite(pin_led_vert,0);digitalWrite(pin_led_rouge,1); break;
    case 3: digitalWrite(pin_led_vert,1);digitalWrite(pin_led_rouge,0); break;
    case 4: digitalWrite(pin_led_vert,0);digitalWrite(pin_led_rouge,0); break;
    default:break;
  }
}