#ifndef A4FeuxTricolores_h  
#define A4FeuxTricolores_h
#include <Arduino.h>

/*
  Plan de cablage pour Lotus Groove:
    > Feux Tricolores n°1: Rouge = D4 / Orange = D3 / Vert D2
    > Feux Tricolores n°2: Rouge = D7 / Orange = D6 / Vert D5
    > Feux pietons: Rouge = A2  / Vert = A0
    > Bouton poussoir: I2C (SCL = pin n°19)
*/

class FeuxTricolores{
  public:
    FeuxTricolores();
    void changer_feu_tricolore (int feu, int couleur);

  private:
    int feu_rouge[2] = {4,7};
    int feu_orange[2] = {3,6};
    int feu_vert[2] = {2,5};
};

class FeuPietons{
  public:
    FeuPietons();
    void changer_feu_pietons (int couleur);

  private:
    int pin_led_rouge = 16;
    int pin_led_vert = 14;
};

#endif
