#include <Arduino.h>
#include "A4PassageNiveau.h"

/*
  Plan de cablage pour Lotus Groove:
    >Servomoteur barrière                 D2(2)
    >Interrupteur pédale de réddition     D3(3)
    >LED feu signalisation voiture        D5(5)
    >LED feu signalisation train          D6(6)
    >Buzzer alarme                        D7(7)
    >Interrupteur pédale d'annonce        D4(4)
*/

PassageNiveau::PassageNiveau(){
  pinMode(2,OUTPUT);
  pinMode(5,OUTPUT);
  pinMode(6,OUTPUT);
  pinMode(7,OUTPUT);
  pinMode(3,INPUT);
  pinMode(14,INPUT);
}

void PassageNiveau::changer_feu_signa (int feu, bool etat){
  digitalWrite(4+feu,etat);
}

void PassageNiveau::init_servo(){
  barriere.attach(2);
}

void PassageNiveau::ouvrir_fermer_barriere (bool etat){
  barriere.write(etat?30:120);
}

void PassageNiveau::play_buzzer(int note, float temps){
  for (long i = 0; i < temps * 1000L; i += note * 2){
    digitalWrite(7, HIGH);
    delayMicroseconds(note);
    digitalWrite(7, LOW);
    delayMicroseconds(note);
  }
}

void PassageNiveau::barriere_angle (float angle){
  if (angle < 0) angle = 0;
  else if (angle > 90) angle = 90;
  barriere.write(120-int(angle));
}